/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.common;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.InvalidAttributeValue;
import java.io.IOException;
import org.apache.http.HttpHost;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class HttpProxyConfig
implements ToXContent {
    public static final HttpProxyConfig USE_DEFAULT = new HttpProxyConfig(Type.USE_DEFAULT_PROXY);
    public static final HttpProxyConfig USE_NONE = new HttpProxyConfig(Type.USE_NO_PROXY);
    private final HttpHost proxy;
    private final Type type;

    public HttpProxyConfig(HttpHost proxy) {
        this.proxy = proxy;
        this.type = Type.USE_SPECIFIC_PROXY;
    }

    public HttpProxyConfig(Type type) {
        this.type = type;
        this.proxy = null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.type == Type.USE_DEFAULT_PROXY) {
            builder.value("default");
        } else if (this.type == Type.USE_NO_PROXY) {
            builder.value("none");
        } else if (this.proxy != null) {
            builder.value(this.proxy.toURI());
        } else {
            builder.value("default");
        }
        return builder;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "HttpProxyConfig [proxy=" + this.proxy + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static HttpProxyConfig create(String value) throws ConfigValidationException {
        if (value == null || "default".equalsIgnoreCase(value)) {
            return USE_DEFAULT;
        }
        if ("none".equalsIgnoreCase(value)) {
            return USE_NONE;
        }
        try {
            return new HttpProxyConfig(HttpHost.create((String)value));
        }
        catch (IllegalArgumentException e) {
            throw new ConfigValidationException(new InvalidAttributeValue(null, (Object)value, (Object)"URI or default or none").cause((Throwable)e));
        }
    }

    static enum Type {
        USE_SPECIFIC_PROXY,
        USE_DEFAULT_PROXY,
        USE_NO_PROXY;

    }
}

